using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.IO;
using System.Windows.Forms;
using Outbound_OpenInterface_Test_App.OutboundCampaignWS;
using System.Web.Services.Protocols;
using System.Collections;
using System.Runtime.Remoting.Messaging;
using System.Threading;

namespace Outbound_OpenInterface_Test_App
{
  public partial class Main : Form
  {  
    //list of Campaign received from web service
    OWCampaigns MyActiveCampaigns = new OWCampaigns();
    
    //used for async web service calling - receiving campaign contacts
    public delegate int MyGetDelegate(DataTable myDataTable, OWCampaigns MyActiveCampaigns, int selectedIndex);


    /// <summary>
    /// constructor
    /// </summary>
    public Main()
    {
      InitializeComponent();

      try
      {
        //first we do is get a list of campaigns
        LoadCamapaigns();
      }
      catch(SoapException ex)
      {
        //error meesage here
      }
    }

    /// <summary>
    /// we a re overwriting this file so we can throw in the 
    /// code to log off the user
    /// </summary>
    /// <param name="disposing"></param>
    protected override void Dispose(bool disposing)
    {
      // logoff agent		
      Logoff();

      if(disposing && (components != null))
      {
        components.Dispose();
      }
      base.Dispose(disposing);
    }

    /// <summary>
    /// when the apps is exiitng, this is called to log the user off
    /// </summary>
    private void Logoff()
    {
      OutboundUtilityWS.OutboundUtilityWS UtilInvoke = new OutboundUtilityWS.OutboundUtilityWS();

      //invoke our log out webservice
      try
      {
        UtilInvoke.OutboundLogoff(GlobalDef.getInstance().MyUserName);
      }
      catch(SoapException ex)
      {
        //error message here
      }
    }

    /// <summary>
    /// upon login, the list is filled with active campaigns
    /// </summary>
    private void LoadCamapaigns()
    {
      //create a link to the web service
      OutboundCampaignWS.OutboundCampaignWS campInvoke = new OutboundCampaignWS.OutboundCampaignWS();
      
      //empty the array so that we dont re-add campaigns
      Campaign_Listbox.Items.Clear();

      //invoke the webservice
      MyActiveCampaigns = campInvoke.GetCampaigns(GlobalDef.getInstance().MySessionKey);

      //add each active campaign name to the list
      if (MyActiveCampaigns.CampaignList != null)
      {
          if (MyActiveCampaigns.CampaignList.Length > 0)
          {
              for (int i = 0; i < MyActiveCampaigns.CampaignList.Length; i++)
              {
                  Campaign_Listbox.Items.Add(MyActiveCampaigns.CampaignList[i].Name);
              }
          }
      }
    }

    /// <summary>
    /// Click on the refresh campaign button 
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void Refresh_Campaign_Button_Click(object sender, EventArgs e)
    {
      LoadCamapaigns();
    }

    /// <summary>
    /// User selects a campaign on the list  
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void Campaign_Listbox_SelectedIndexChanged(object sender, EventArgs e)
    {
      //disable update button untill we get all of the campaings contacts
      Refresh_Campaign_Button.Enabled = false;
      Campaign_Listbox.Enabled = false;

      //empty our message field
      Message_Field.Text = "";
      Message_Field.Refresh();

      //get selected index
      int selectedIndex = Campaign_Listbox.SelectedIndex;

      //wi01216450 - 10/7/2015 - etummon
      //when background of campaign listbox gets click
      //selectedIndex = -1 and application crash. Put
      //in if statement to stop this crash.
      if (selectedIndex != -1)
      {
          //get Camapign Status
          OWStatus campaignStatus = new OWStatus();
          campaignStatus = MyActiveCampaigns.CampaignList[selectedIndex].Status;
          Campaign_Status_Field.Text = campaignStatus.Name;

          //get contacts open
          Contacts_Open_Field.Text = System.Convert.ToString((MyActiveCampaigns.CampaignList[selectedIndex].NumberOfContacts - MyActiveCampaigns.CampaignList[selectedIndex].NumberOfContactsClosed));

          //get contacts closed
          Contacts_Closed_Field.Text = MyActiveCampaigns.CampaignList[selectedIndex].NumberOfContactsClosed.ToString();

          //get contacts processed
          Contacts_Procesed_Field.Text = MyActiveCampaigns.CampaignList[selectedIndex].NumberOfContactsProcessed.ToString();

          //get call rate - no longer used in AACC
          //Call_Rate_Field.Text = MyActiveCampaigns.CampaignList[selectedIndex].LoadContactsPerInterval.ToString();

          //get priorty
          Priorty_Field.Text = MyActiveCampaigns.CampaignList[selectedIndex].Priority.ToString();

          //get owner
          Owner_Field.Text = MyActiveCampaigns.CampaignList[selectedIndex].Owner.ToString();

          //get Campaign ID
          ID_Field.Text = MyActiveCampaigns.CampaignList[selectedIndex].ID.ToString();

          //setup a datatable for the contacts of the selects campaign
          DataTable myDataTable = GlobalDef.getInstance().MyReceivedContactsTable;
          if (myDataTable != null)
          {
              myDataTable.Clear();
          }
          myDataTable = (DataTable)MakeNamesTable();

          //reset our datagrid source our datagrid
          userControl1.DataSource = null;
          userControl1.DataSource = myDataTable;

          //call the Async Method GetContactDetails
          MyGetDelegate GetContacts = GetContactDetails;
          IAsyncResult myAsyncThread = GetContacts.BeginInvoke(myDataTable, MyActiveCampaigns, selectedIndex, null, null);
          do
          {
              Application.DoEvents();
              Message_Field.Text = GlobalDef.getInstance().MyThreadProcessString;

              //only refresh the grib if we have soemthing to there to show
              if (Message_Field.Text != "")
              {
                  userControl1.Refresh();
              }
              Message_Field.Refresh();
          }
          while (!myAsyncThread.IsCompleted);

          //bug while dynamic adding rows to grid, vertical scroll bar disappers, need to re-add the data source
          userControl1.DataSource = null;
          userControl1.DataSource = myDataTable;
      }
      //now that we have finished loaded the contacts we can re-enable the buttons
      Campaign_Listbox.Enabled = true;
      Refresh_Campaign_Button.Enabled = true;
      Message_Field.Text = "";
      Message_Field.Refresh();
    
    }
    
    /// <summary>
    /// Create a new DataTable with columes
    /// </summary>
    /// <returns></returns>
    private object MakeNamesTable()
    {
      // Create a new DataTable titled 'Contacts.'
      DataTable namesTable = new DataTable("Contacts");

      //create array of column header
      string[] columns = new string[16];
      columns[0] = "Title";
      columns[1] = "First Name";
      columns[2] = "Last Name";
      columns[3] = "International Code";
      columns[4] = "Area Code";
      columns[5] = "Phone Number";
      columns[6] = "Address Line 1";
      columns[7] = "Address Line 2";
      columns[8] = "Address Line 3";
      columns[9] = "Address Line 4";
      columns[10] = "Address Line 5";
      columns[11] = "Country";
      columns[12] = "Post Code";
      columns[13] = "Prefered Agent ID";
      columns[14] = "Contact ID";
      columns[15] = "Skillset ID";

      for(int i = 0; i < columns.Length; i++)
      {
        // Add three column objects to the table.
        DataColumn idColumn = new DataColumn();
        idColumn.DataType = System.Type.GetType("System.String");
        idColumn.ColumnName = columns[i].ToString();
        namesTable.Columns.Add(idColumn);
      }

      // Return the new DataTable.
      return namesTable;
    }

    /// <summary>
    /// My Async Method for getting campaign contacts
    /// </summary>
    /// <param name="myDataTable"></param>
    /// <param name="MyActiveCampaigns"></param>
    /// <param name="selectedIndex"></param>
    /// <returns></returns>
    static int GetContactDetails(DataTable myDataTable, OWCampaigns MyActiveCampaigns, int selectedIndex)
    {
      //set up a link to the web service
      OutboundCampaignWS.OutboundCampaignWS campInvoke = new OutboundCampaignWS.OutboundCampaignWS();
      OutboundCampaignWS.OWContacts contDetails = new OutboundCampaignWS.OWContacts();
      
      //get campaign contact
      int contactCounter = 0;
      long nextContactID = 0;
      DataRow myNewRow;
      GlobalDef.getInstance().MyThreadProcessString = "";
      try
      {
        do
        {
          //invoke the web service

          contDetails = campInvoke.Get200CampaignContacts(MyActiveCampaigns.CampaignList[selectedIndex].ID, nextContactID, GlobalDef.getInstance().MySessionKey);

          //now add this to our dataTable  
          for(int i = 0; i < contDetails.ContactList.Length; i++)
          {
            //create data row
            //add each value to the data table if it exists
            myNewRow = myDataTable.NewRow();

            myNewRow["Contact ID"] = contDetails.ContactList[i].ContactID;

            if(contDetails.ContactList[i].Title != null)
            {
              myNewRow["Title"] = "";
            }
            else
            {
              myNewRow["Title"] = contDetails.ContactList[i].Title;
            }
            if(contDetails.ContactList[i].FirstName != null)
            {
              myNewRow["First Name"] = contDetails.ContactList[i].FirstName;
            }
            else
            {
              myNewRow["First Name"] = "";
            }
            if(contDetails.ContactList[i].LastName != null)
            {
              myNewRow["Last Name"] = contDetails.ContactList[i].LastName;
            }
            else
            {
              myNewRow["Last Name"] = "";
            }
            if(contDetails.ContactList[i].PhoneNumber.IntCode != null)
            {
              myNewRow["International Code"] = contDetails.ContactList[i].PhoneNumber.IntCode;
            }
            else
            {
              myNewRow["International Code"] = "";
            }
            if(contDetails.ContactList[i].PhoneNumber.AreaCode != null)
            {
              myNewRow["Area Code"] = contDetails.ContactList[i].PhoneNumber.AreaCode;
            }
            else
            {
              myNewRow["Area Code"] = "";
            }
            if(contDetails.ContactList[i].PhoneNumber.PhoneNo != null)
            {
              myNewRow["Phone Number"] = contDetails.ContactList[i].PhoneNumber.PhoneNo;
            }
            else
            {
              myNewRow["Phone Number"] = "";
            }

            if(contDetails.ContactList[i].Address.AddressLine1 != null)
            {
              myNewRow["Address Line 1"] = contDetails.ContactList[i].Address.AddressLine1;
            }
            else
            {
              myNewRow["Address Line 1"] = "";
            }

            if(contDetails.ContactList[i].Address.AddressLine2 != null)
            {
              myNewRow["Address Line 2"] = contDetails.ContactList[i].Address.AddressLine2;
            }
            else
            {
              myNewRow["Address Line 2"] = "";
            }

            if(contDetails.ContactList[i].Address.AddressLine3 != null)
            {
              myNewRow["Address Line 3"] = contDetails.ContactList[i].Address.AddressLine3;
            }
            else
            {
              myNewRow["Address Line 3"] = "";
            }

            if(contDetails.ContactList[i].Address.AddressLine4 != null)
            {
              myNewRow["Address Line 4"] = contDetails.ContactList[i].Address.AddressLine4;
            }
            else
            {
              myNewRow["Address Line 4"] = "";
            }

            if(contDetails.ContactList[i].Address.AddressLine5 != null)
            {
              myNewRow["Address Line 5"] = contDetails.ContactList[i].Address.AddressLine5;
            }
            else
            {
              myNewRow["Address Line 5"] = "";
            }

            if(contDetails.ContactList[i].Address.Country != null)
            {
              myNewRow["Country"] = contDetails.ContactList[i].Address.Country;
            }
            else
            {
              myNewRow["Country"] = "";
            }

            if(contDetails.ContactList[i].Address.PostCode != null)
            {
              myNewRow["Post Code"] = contDetails.ContactList[i].Address.PostCode;
            }
            else
            {
              myNewRow["Post Code"] = "";
            }

            if(contDetails.ContactList[i].PreferredAgentSpecified1)
            {
              myNewRow["Prefered Agent ID"] = contDetails.ContactList[i].PreferredAgentID;
            }
            else
            {
              myNewRow["Prefered Agent ID"] = -1;
            }

            if (contDetails.ContactList[i].SkillsetID != 0)
            {
                myNewRow["Skillset ID"] = contDetails.ContactList[i].SkillsetID;
            }
            else
            {
                myNewRow["Skillset ID"] = -1;
            }

            //get the custom fields (if any)
            if(contDetails.ContactList[i].CustomFieldList != null)
            {
              foreach(OWCustomField This_CF_Field in contDetails.ContactList[i].CustomFieldList)
              {
                //add it to out data source
                DataColumn idColumn = new DataColumn();
                idColumn.DataType = System.Type.GetType("System.String");
                idColumn.ColumnName = This_CF_Field.Name;
                idColumn.Caption = "CF_Field";

                //only add a new CF column if it doesnt already exist and it the first row
                if((!myDataTable.Columns.Contains(idColumn.ColumnName))&&(i==0))
                  myDataTable.Columns.Add(idColumn);

                try
                {
                  if(This_CF_Field.Text != null)
                  {
                    myNewRow[This_CF_Field.Name] = This_CF_Field.Text;
                  }
                  else
                  {
                    myNewRow[This_CF_Field.Name] = "";
                  }
                }
                catch
                {
                  GlobalDef.getInstance().MyThreadProcessString = "Error Reading Custom Fields";
                }

              }
            }
            myDataTable.Rows.Add(myNewRow);
            GlobalDef.getInstance().MyThreadProcessString = "Currently Processed " + (contactCounter + i + 1) + " out of " + MyActiveCampaigns.CampaignList[selectedIndex].NumberOfContacts;
          }
          //now we have a max of 200 contacts received
          contactCounter += 200;

          //get next contact id
          nextContactID = contDetails.ContactList[contDetails.ContactList.Length - 1].ContactID;
        }
        //keep going untill we have all the contacts from the campaign
        while(contactCounter < MyActiveCampaigns.CampaignList[selectedIndex].NumberOfContacts);

      }
      catch
      {
        GlobalDef.getInstance().MyThreadProcessString = "Error Reading Contacts";
      }
      //update global var 
      GlobalDef.getInstance().MyReceivedContactsTable = myDataTable;

      //sleep for 1 second so that the process messages can be read
      Thread.Sleep(1000);

      return 0;
    }

    /// <summary>
    /// Clicked Close Contact button
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void Close_Contact_Button_Click(object sender, EventArgs e)
    {
      int selectedIndex = Campaign_Listbox.SelectedIndex;
      if(selectedIndex != -1)
      {
        Close_Contact newForm = new Close_Contact(MyActiveCampaigns, selectedIndex);
        newForm.ShowDialog();
      }
      else
      {
        MessageBox.Show("You need to Select a Campaign To close from", "", MessageBoxButtons.OK);
      } 
    }

    /// <summary>
    /// Clicked Get Contact Status button
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void Get_Contact_Status_Button_Click(object sender, EventArgs e)
    {
      int selectedIndex = Campaign_Listbox.SelectedIndex;
      if(selectedIndex != -1)
      {
        Get_Contact_Status newForm = new Get_Contact_Status(MyActiveCampaigns, selectedIndex);
        newForm.ShowDialog();
      }
      else
      {
        MessageBox.Show("You need to Select a Campaign To get from", "", MessageBoxButtons.OK);
      } 
    }

    /// <summary>
    /// Clicked Get Contact ID button
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void Get_Contact_ID_Button_Click(object sender, EventArgs e)
    {
      int selectedIndex = Campaign_Listbox.SelectedIndex;
      if(selectedIndex != -1)
      {
        Get_Contact_ID newForm = new Get_Contact_ID(MyActiveCampaigns, selectedIndex);
        newForm.ShowDialog();
      }
      else
      {
        MessageBox.Show("You need to Select a Campaign To get from", "", MessageBoxButtons.OK);
      } 
    }
    
    /// <summary>
    /// Clicked Add Contact button
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    private void Add_Contact_Button_Click(object sender, EventArgs e)
    {
      int selectedIndex = Campaign_Listbox.SelectedIndex;
      if(selectedIndex != -1)
      {
        Add_Contact newForm = new Add_Contact(MyActiveCampaigns, selectedIndex, (DataTable)userControl1.DataSource);
        newForm.ShowDialog();
      }
      else
      {
        MessageBox.Show("You need to Select a Campaign To get from", "", MessageBoxButtons.OK);
      } 
    }

    protected override void OnPaint(System.Windows.Forms.PaintEventArgs e)
    {
      try
      {
        base.OnPaint(e);
      }
      catch(Exception ex)
      {
        this.Invalidate();
      }
    }

    private void FindContact_Click(object sender, EventArgs e)
    {
      int selectedIndex = Campaign_Listbox.SelectedIndex;
      if(selectedIndex != -1)
      {
        Find_Contact newForm = new Find_Contact(MyActiveCampaigns, selectedIndex);
        newForm.ShowDialog();
      }
      else
      {
        MessageBox.Show("You need to Select a Campaign To get from", "", MessageBoxButtons.OK);
      }
    }
  }
}